"""Tests for tuple exercises"""
from helpers import BaseTestCase
from tuples import hotdog_counts, swap_ends, get_earliest, name_key, sort_names


class HotDogCountsTests(BaseTestCase):

    """Tests for hotdog_counts."""

    def test_example_cases(self):
        self.assertEqual(hotdog_counts(7), (1, 1))
        self.assertEqual(hotdog_counts(10), (2, 1))
        self.assertEqual(hotdog_counts(14), (2, 2))
        self.assertEqual(hotdog_counts(20), (3, 2))
        self.assertEqual(hotdog_counts(21), (3, 3))
        self.assertEqual(hotdog_counts(28), (4, 3))

    def test_zero_guests(self):
        self.assertEqual(hotdog_counts(0), (0, 0))

    def test_one_guest(self):
        self.assertEqual(hotdog_counts(1), (1, 1))

    def test_eight_guests(self):
        self.assertEqual(hotdog_counts(8), (1, 1))

    def test_nine_guests(self):
        self.assertEqual(hotdog_counts(9), (2, 1))

    def test_ten_guests(self):
        self.assertEqual(hotdog_counts(10), (2, 1))

    def test_eleven_guests(self):
        self.assertEqual(hotdog_counts(11), (2, 2))

    def test_large_number_of_guests(self):
        self.assertEqual(hotdog_counts(100), (13, 10))

    def test_very_large_number_of_guests(self):
        self.assertEqual(hotdog_counts(1000000), (125000, 100000))


class SwapEndsTests(BaseTestCase):

    """Tests for swap_ends."""

    def test_one_item(self):
        numbers = [1]
        swap_ends(numbers)
        self.assertEqual(numbers, [1])

    def test_two_items(self):
        numbers = [1, 2]
        swap_ends(numbers)
        self.assertEqual(numbers, [2, 1])

    def test_three_items(self):
        numbers = [1, 2, 3]
        swap_ends(numbers)
        self.assertEqual(numbers, [3, 2, 1])

    def test_four_items(self):
        numbers = [1, 2, 3, 4]
        swap_ends(numbers)
        self.assertEqual(numbers, [4, 2, 3, 1])

    def test_five_items(self):
        numbers = [1, 2, 3, 4, 5]
        swap_ends(numbers)
        self.assertEqual(numbers, [5, 2, 3, 4, 1])

    def test_return_value_is_None(self):
        numbers = [1, 2, 3, 4, 5]
        self.assertIsNone(swap_ends(numbers))


class GetEarliestTests(BaseTestCase):

    """Tests for get_earliest."""

    def test_same_month_and_day(self):
        self.assertEqual(get_earliest("01/27/1832", "01/27/1756"), "01/27/1756")

    def test_february_29th(self):
        self.assertEqual(get_earliest("02/29/1972", "12/21/1946"), "12/21/1946")

    def test_smaller_month_bigger_day(self):
        self.assertEqual(get_earliest("02/24/1946", "03/21/1946"), "02/24/1946")

    def test_same_month_and_year(self):
        self.assertEqual(get_earliest("06/21/1958", "06/24/1958"), "06/21/1958")


class NameKeyTests(BaseTestCase):

    """Tests for name_key."""

    def test_michael_gambino(self):
        self.assertEqual(name_key("Michael Gambino"), ("Gambino", "Michael"))

    def test_suzanne_smith(self):
        self.assertEqual(name_key("Suzanne Smith"), ("Smith", "Suzanne"))


class SortNamesTests(BaseTestCase):

    """Tests for sort_names."""

    def test_sort_by_last_name(self):
        self.assertEqual(
            sort_names(["Ben Speigel", "Tanya Jackson"]),
            ["Tanya Jackson", "Ben Speigel"],
        )
        self.assertEqual(
            sort_names(list(reversed(["Ben Speigel", "Tanya Jackson"]))),
            ["Tanya Jackson", "Ben Speigel"],
        )

    def test_same_last_name(self):
        self.assertEqual(
            sort_names(["Evelyn Moore", "Jill Moore"]),
            ["Evelyn Moore", "Jill Moore"],
        )
        self.assertEqual(
            sort_names(list(reversed(["Evelyn Moore", "Jill Moore"]))),
            ["Evelyn Moore", "Jill Moore"],
        )

    def test_three_names(self):
        self.assertEqual(
            sort_names(["Evelyn Moore", "Jill Moore", "Tanya Jackson"]),
            ["Tanya Jackson", "Evelyn Moore", "Jill Moore"],
        )

    def test_four_names(self):
        self.assertEqual(
            sort_names(["Ben Speigel", "Evelyn Moore", "Jill Moore", "Tanya Jackson"]),
            ["Tanya Jackson", "Evelyn Moore", "Jill Moore", "Ben Speigel"],
        )

    def test_already_sorted(self):
        self.assertEqual(
            sort_names(["Tanya Jackson", "Evelyn Moore", "Jill Moore", "Ben Speigel"]),
            ["Tanya Jackson", "Evelyn Moore", "Jill Moore", "Ben Speigel"],
        )


if __name__ == "__main__":
    from helpers import error_message

    error_message()
