"""Tests for star exercises"""
import unittest


from stars import transpose, sum_each, html_tag


class TransposeTests(unittest.TestCase):

    """Tests for transpose."""

    def test_empty(self):
        self.assertEqual(transpose([]), [])

    def test_single_item(self):
        self.assertEqual(transpose([[1]]), [[1]])

    def test_two_rows(self):
        self.assertEqual(transpose([[1, 2], [3, 4]]), [[1, 3], [2, 4]])

    def test_three_rows(self):
        self.assertEqual(
            transpose([[1, 2, 3], [4, 5, 6], [7, 8, 9]]),
            [[1, 4, 7], [2, 5, 8], [3, 6, 9]],
        )


class SumEachTests(unittest.TestCase):

    """tests for sum_each."""

    def test_list_of_two_two_item_tuples(self):
        self.assertEqual(sum_each((1, 2), (4, 5)), (5, 7))

    def test_list_of_three_two_item_tuples(self):
        self.assertEqual(sum_each((1, 2), (4, 5), (7, 8), (1, 1)), (13, 16))

    def test_list_of_4_3_item_tuples(self):
        self.assertEqual(
            sum_each((1, 2, 3), (4, 5, 6), (7, 8, 9), (1, 1, 0)),
            (13, 16, 18),
        )


class HTMLTagTests(unittest.TestCase):

    """Tests for html_tag."""

    def assertTagEqual(self, tag1, tag2):
        split1 = tag1[1:-1].split(" ")
        name1, attrs1 = split1[0], split1[1:]
        split2 = tag2[1:-1].split(" ")
        name2, attrs2 = split2[0], split2[1:]
        self.assertEqual(name1, name2)
        self.assertEqual(sorted(attrs1), sorted(attrs2))
        self.assertEqual(tag1[0], tag2[0])
        self.assertEqual(tag1[-1], tag2[-1])

    def test_input(self):
        html = html_tag("input", type="email", name="email", placeholder="E-mail")
        expected = '<input name="email" placeholder="E-mail" type="email">'
        self.assertTagEqual(html, expected)

    def test_img(self):
        html = html_tag("img", src="https://placehold.it/10x10", alt="Sample")
        expected = '<img alt="Sample" src="https://placehold.it/10x10">'
        self.assertTagEqual(html, expected)


if __name__ == "__main__":
    from helpers import error_message

    error_message()
