from pathlib import Path
import subprocess
import sys

from test_data import MODULES

tester = Path(__file__).parent / "test.py"

weights = []


for n, (module, exercises) in enumerate(MODULES.items()):
    for m, exercise in enumerate(exercises):
        weight = n + 3.4**(m+1)+m
        weights.append((weight, exercise, module))


incomplete = 0
for weight, exercise, module in sorted(weights):
    completed = subprocess.run(
        [sys.executable, tester, exercise],
        capture_output=True,
    )
    done = completed.returncode == 0
    print(f"[{'x' if done else ' '}]", exercise, f"({module})")
    if not done:
        incomplete += 1
    if incomplete > 15:
        break
