"""Tests for dunder exercises"""
import unittest

from dunder import CaselessString, EasyDict, CyclicList


class CaselessStringTests(unittest.TestCase):

    """Tests for CaselessString."""

    def test_caseless_strings(self):
        s1 = CaselessString("Hello there")
        s2 = CaselessString("hello there")
        s3 = CaselessString("HELLO THERE")
        self.assertEqual(s1, s2)
        self.assertEqual(s2, s3)


class EasyDictTests(unittest.TestCase):

    """Tests for EasyDict."""

    def test_read_from_attribute(self):
        a = EasyDict()
        a["shoe"] = "blue"
        self.assertEqual(a["shoe"], "blue")
        self.assertEqual(a.shoe, "blue")

    def test_write_to_attribute(self):
        a = EasyDict()
        a.car = "green"
        self.assertEqual(a.car, "green")
        self.assertEqual(a["car"], "green")


class CyclicListTests(unittest.TestCase):

    """Tests for CyclicList."""

    def test_cycles(self):
        numbers = CyclicList([1, 2, 3, 4])
        self.assertEqual(numbers[1], 2)
        self.assertEqual(numbers[2], 3)
        self.assertEqual(numbers[10], 3)
        self.assertEqual(numbers[35], 4)
        expected = [1, 2, 3, 4, 1, 2, 3, 4, 1, 2]
        nums = [x for x, _ in zip(numbers, range(10))]
        self.assertEqual(nums, expected)


if __name__ == "__main__":
    from helpers import error_message

    error_message()
