"""Tests for date exercises"""
import datetime
import unittest

from helpers import run_program, ModuleTestCase
from dates import fourth_thursday


class SomeDayTests(ModuleTestCase):

    """Tests for someday.py."""

    module_path = "someday.py"

    def run_repeatedly(self, args, times):
        outputs = (run_program("someday.py", args) for _ in range(times))
        return {o.strip() for o in outputs}

    def test_january_1999(self):
        args = ["1999-01-01", "1999-01-31"]
        expected = {
            "1999-01-01",
            "1999-01-02",
            "1999-01-03",
            "1999-01-04",
            "1999-01-05",
            "1999-01-06",
            "1999-01-07",
            "1999-01-08",
            "1999-01-09",
            "1999-01-10",
            "1999-01-11",
            "1999-01-12",
            "1999-01-13",
            "1999-01-14",
            "1999-01-15",
            "1999-01-16",
            "1999-01-17",
            "1999-01-18",
            "1999-01-19",
            "1999-01-20",
            "1999-01-21",
            "1999-01-22",
            "1999-01-23",
            "1999-01-24",
            "1999-01-25",
            "1999-01-26",
            "1999-01-27",
            "1999-01-28",
            "1999-01-29",
            "1999-01-30",
            "1999-01-31",
        }
        outputs = self.run_repeatedly(args, times=500)
        self.assertEqual(outputs, expected)

    def test_leap_year(self):
        args = ["2000-02-25", "2000-03-03"]
        expected = {
            "2000-02-25",
            "2000-02-26",
            "2000-02-27",
            "2000-02-28",
            "2000-02-29",
            "2000-03-01",
            "2000-03-02",
            "2000-03-03",
        }
        outputs = self.run_repeatedly(args, times=100)
        self.assertEqual(outputs, expected)

    def test_one_argument(self):
        with self.assertRaises(BaseException):
            run_program("someday.py", ["2000-01-01"])

    def test_no_arguments(self):
        with self.assertRaises(BaseException):
            run_program("someday.py", [])


class FourthThursdayTests(unittest.TestCase):

    """Tests for fourth_thursday."""

    def test_aug_2015(self):
        self.assertEqual(fourth_thursday(2015, 8), datetime.date(2015, 8, 27))

    def test_sept_2015(self):
        self.assertEqual(fourth_thursday(2015, 9), datetime.date(2015, 9, 24))

    def test_oct_2015(self):
        self.assertEqual(
            fourth_thursday(2015, 10),
            datetime.date(2015, 10, 22),
        )

    def test_jan_2016(self):
        self.assertEqual(fourth_thursday(2016, 1), datetime.date(2016, 1, 28))

    def test_feb_2016(self):
        self.assertEqual(fourth_thursday(2016, 2), datetime.date(2016, 2, 25))


if __name__ == "__main__":
    from helpers import error_message

    error_message()
